/*
 * Decompiled with CFR 0.152.
 */
package com.exfantasy.mclib.Utils;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class TeleportHelper {
    public static void teleportEntityInCube(ServerLevel level, LivingEntity entity, Vec3 center, float size) {
        if (entity == null || !level.m_46749_(entity.m_20183_())) {
            return;
        }
        float halfSize = size / 2.0f;
        Vec3 randomPos = null;
        for (int attempts = 0; attempts < 10; ++attempts) {
            randomPos = TeleportHelper.generateRandomPosition(center, halfSize);
        }
        if (randomPos != null) {
            TeleportHelper.teleportToValidYPosition(level, entity, randomPos);
        }
    }

    private static Vec3 generateRandomPosition(Vec3 center, float halfSize) {
        double minX = center.f_82479_ - (double)halfSize;
        double maxX = center.f_82479_ + (double)halfSize;
        double minY = center.f_82480_ - (double)halfSize;
        double maxY = center.f_82480_ + (double)halfSize;
        double minZ = center.f_82481_ - (double)halfSize;
        double maxZ = center.f_82481_ + (double)halfSize;
        return new Vec3(minX + Math.random() * (maxX - minX), minY + Math.random() * (maxY - minY), minZ + Math.random() * (maxZ - minZ));
    }

    private static void teleportToValidYPosition(ServerLevel level, LivingEntity entity, Vec3 pos) {
        double y;
        for (y = pos.f_82480_; !level.m_46859_(BlockPos.m_274561_((double)pos.f_82479_, (double)y, (double)pos.f_82481_).m_7495_()) && y > (double)level.m_141937_(); y -= 1.0) {
        }
        if (y >= (double)level.m_141937_()) {
            entity.m_6021_(pos.f_82479_, y, pos.f_82481_);
        } else {
            System.out.println("Failed to find a valid Y position for teleportation.");
        }
    }
}

